<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

$proxyList = file("proxies.txt", FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$testURL = "https://www.google.com"; // Test URL

if (!$proxyList) {
    die("No proxies found in proxies.txt");
}

echo "<pre>";

foreach ($proxyList as $proxy) {
    list($proxyIp, $proxyPort) = explode(":", $proxy);

    echo "Testing proxy: $proxyIp:$proxyPort ... ";
    ob_flush();
    flush();

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $testURL);
    curl_setopt($ch, CURLOPT_PROXY, $proxyIp);
    curl_setopt($ch, CURLOPT_PROXYPORT, $proxyPort);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0");

    $response = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);

    if ($response) {
        echo "✅ WORKING\n";
        file_put_contents("working_proxies.txt", "$proxy\n", FILE_APPEND);
    } else {
        echo "❌ FAILED: $err\n";
    }

    ob_flush();
    flush();

    // Small delay to prevent overloading the server
    sleep(2);
}

echo "</pre>";
?>
